/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.sprinkler;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.terrasoil.TileTerraPreta;
import com.lothrazar.cyclic.capabilities.block.FluidTankBase;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.FluidHelpers;
import com.lothrazar.cyclic.util.ParticleUtil;
import com.lothrazar.cyclic.util.ShapeUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileSprinkler
extends TileBlockEntityCyclic {
    public static final int CAPACITY = 1000;
    public static ForgeConfigSpec.IntValue TIMER_FULL;
    public static ForgeConfigSpec.IntValue WATERCOST;
    private static final int RAD = 4;
    public FluidTankBase tank = new FluidTankBase(this, 1000, p -> p.getFluid() == Fluids.f_76193_);
    LazyOptional<FluidTankBase> fluidCap = LazyOptional.of(() -> this.tank);
    private int shapeIndex = 0;

    public TileSprinkler(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.SPRINKLER.get(), pos, state);
        this.tank = new FluidTankBase(this, 1000, p -> p.getFluid() == Fluids.f_76193_);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileSprinkler e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileSprinkler e) {
        e.tick();
    }

    public void tick() {
        --this.timer;
        if (this.timer > 0) {
            return;
        }
        this.timer = (Integer)TIMER_FULL.get();
        this.grabWater();
        if ((Integer)WATERCOST.get() > 0 && this.tank.getFluidAmount() < (Integer)WATERCOST.get()) {
            return;
        }
        List<BlockPos> shape = ShapeUtil.squareHorizontalFull(this.f_58858_, 4);
        ++this.shapeIndex;
        if (this.shapeIndex >= shape.size()) {
            this.shapeIndex = 0;
        }
        if (this.f_58857_.f_46443_ && TileTerraPreta.isValidGrow(this.f_58857_, shape.get(this.shapeIndex))) {
            ParticleUtil.spawnParticle(this.f_58857_, (ParticleOptions)ParticleTypes.f_123804_, shape.get(this.shapeIndex), 9);
        }
        if (TileTerraPreta.grow(this.f_58857_, shape.get(this.shapeIndex), 1.0)) {
            this.tank.drain((Integer)WATERCOST.get(), IFluidHandler.FluidAction.EXECUTE);
            TileTerraPreta.grow(this.f_58857_, shape.get(this.shapeIndex), 1.0);
        }
    }

    private void grabWater() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        BlockState down = this.f_58857_.m_8055_(this.f_58858_.m_7495_());
        if (this.tank.isEmpty() && down.m_60734_() == Blocks.f_49990_ && down.m_60819_().m_76170_()) {
            this.tank.fill(new FluidStack((Fluid)Fluids.f_76193_, 1000), IFluidHandler.FluidAction.EXECUTE);
            this.f_58857_.m_46597_(this.f_58858_.m_7495_(), Blocks.f_50016_.m_49966_());
            return;
        }
        BlockEntity below = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
        if (below != null) {
            FluidHelpers.tryFillPositionFromTank(this.f_58857_, this.f_58858_, Direction.DOWN, (IFluidHandler)below.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null), 1000);
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        CompoundTag fluid = tag.m_128469_("fluid");
        this.tank.readFromNBT(fluid);
        this.shapeIndex = tag.m_128451_("shapeIndex");
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        CompoundTag fluid = new CompoundTag();
        this.tank.writeToNBT(fluid);
        tag.m_128365_("fluid", (Tag)fluid);
        tag.m_128405_("shapeIndex", this.shapeIndex);
        super.m_183515_(tag);
    }

    public void invalidateCaps() {
        this.fluidCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public FluidStack getFluid() {
        return this.tank == null ? FluidStack.EMPTY : this.tank.getFluid();
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }
}

